﻿
using System;
using System.Linq;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.DTO.ParticipatingIndividual;
using HIPS.ServiceContracts.Common.DTO.UserIdentity;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Documents
    ///                                 Version 1.2 — 12 September 2012
    /// Use Case #:	    CPCD_Common_Producer
    /// Use Case Name:	Produce a clinical document
    /// User story:
    /// A conformant clinical document is produced by the user using the software or automatically by the software.
    /// </summary>
    [TestClass]
    public class CPCD_P_CP441_2_1A : CcaTest
    {
        /// <summary>
        /// If the clinical document is to be sent to the PCEHR System:
        ///
        /// a. Author a CDA document that references an attachment that is one of the disallowed types.
        ///
        /// b. Verify the software does not allow the attachment to be included in a CDA package to be sent to the PCEHR System.
        /// </summary>
        [TestMethod]
        [TestCategory("CD_CCA_1A")]
        public void ClinicalDocuments_1A_CPCD_P_CP441_2()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;

            byte[] pdf = patient.GetPDF("1A_Sample_Upload");


            DateTime admission = patient.TargetEpisode.AdmissionDate;
            LocalUser user = patient.GetDTOLocalTestUser();

            ParticipatingProvider provider = CcaPatient.ParticipatingProvider;
            //ParticipatingProvider provider = new ParticipatingProvider()
            //{
            //    FamilyName = "SANDEEN",
            //    GivenNames = "MILO",
            //    Hpii = "8003619900000081",
            //    Title = null,
            //    Suffix = null,
            //    LocalIdentifier = null
            //};

            HIPS.ServiceContracts.Common.DTO.PatientIdentifier.Mrn patientIdentifier = new HIPS.ServiceContracts.Common.DTO.PatientIdentifier.Mrn()
            {
                Value = patient.TargetHospitalPatient.Mrn,
                HospitalCode = patient.TargetPatientIdentifier.HospitalCode,
                HospitalCodeSystem = patient.TargetPatientIdentifier.HospitalCodeSystem
            };

            CdaHeaderMetadata metadata = new CdaHeaderMetadata()
            {
                AdmissionDateTime = admission,
                DischargeDateTime = admission.AddDays(1),
                DocumentAuthor = provider,
                DocumentCreationDateTime = DateTime.Now,
                LegalAuthenticator = provider,
                ModeOfSeparation = ModeOfSeparation.Home,
                ResponsibleHealthProfessional = provider,
                SourceDocumentStatus = SourceDocumentStatus.Interim,
                Specialty = "General Practitioner"
            };

            CdaAttachment[] attachments = new CdaAttachment[1]
            {
                new CdaAttachment()
                {
                    FileName = "BAD.EXE",
                    Content = new byte[] { 2, 3, 4 },
                    Caption = "Do not upload",
                    AttachmentType = AttachmentType.AttachedDocumentPdf
                }
            };

            UploadDischargeSummaryLevel1ARequest request = new UploadDischargeSummaryLevel1ARequest
                                                            {
                                                                User = user,
                                                                PdfDocument = pdf,
                                                                PatientIdentifier = patientIdentifier,
                                                                CdaHeaderMetadata = metadata,
                                                                Attachments = attachments.ToList()
                                                            };

            UploadDischargeSummaryLevel1AResponse response = new UploadDischargeSummaryLevel1AResponse();

            try
            {
                response = ProxyHelper.PcehrServiceV2Proxy.UploadOrSupersedeDischargeSummaryLevel1A(request);
            }
            catch (FaultException<ServiceOperationFault> fe)
            {
                LogAssert.AreEqual("InvalidDocument", fe.Detail.Type, DialogueResource.HipsServiceUploadDocument);

                LogAssert.AreEqual("Attachment BAD.EXE is not a supported type for uploading to PCEHR.", fe.Detail.Message, DialogueResource.HipsServiceUploadDocument);

                LogAssert.ExpectResponseStatus(ResponseStatus.None, response.Status, DialogueResource.HipsServiceUploadDocument);
            }
        }
    }
}